package JavaPonies;
/*
 * This is the structure for Pony behaviors
 */
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import javax.swing.ImageIcon;


public class Behavior {
    public String Name;
    public String Pony_Name;
    public double chance_of_occurance;
    public double MaxDuration; //seconds
    public double MinDuration; //seconds
    public double speed;
    
    public ImageIcon current_image;
    
    public ImageIcon right_image;
    public String right_image_path;
    public ImageIcon left_image;
    public String left_image_path;

    public WinMain.AllowedMoves Allowed_Movement;

    public Date end_time = new Date();
    public boolean vertical = false;
    public boolean horizontal = false;
    public boolean up = false;
    public boolean right = true;

    public String Linked_Behavior_Name = "";
    public Behavior Linked_Behavior = null;
    
    public String Start_Line_Name = "";
    public String End_Line_Name = "";
    
    public Speaking_Line Start_Line = null;
    public Speaking_Line End_Line = null;
    
    public boolean Skip = false;
    
    public int destination_xcoord = 0;
    public int destination_ycoord = 0;
    public String follow_object_name = "";
    public Window follow_object;
    
    public int delay = 0;
    
    public List<effect> Effects = new LinkedList<effect>();
    
    public boolean blocked = false;
    
    // Change direction when reaching a boundary
    public void Bounce(Pony pony, Point current_location, Point new_location, double x_movement, double y_movement, GraphicsDevice current_screen) {
    	if (x_movement == 0 && y_movement == 0)
    		return;
    	
    	// if we are moving in a simple direction (up/down, left/right) just reverse direction
    	if (x_movement == 0 && y_movement != 0) {
    		up = !up;
    		return;
    	}
    	if (x_movement != 0 && y_movement == 0) {
    		right = !right;
    		return;
    	}
    	
    	// if we were moving in a composite direction, we need to determine which component is bad
    	boolean x_bad = false;
    	boolean y_bad = false;
    	
        Point new_location_x = new Point(new_location.x, current_location.y);
        Point new_location_y = new Point(current_location.x, new_location.y);

        if (x_movement != 0 && y_movement != 0) {
	        if (!pony.IsPonyOnScreen(current_location, new_location_x, WinMain.screens_to_use) || pony.IsPonyInAvoidanceArea(new_location_x, current_screen)) {
	        	x_bad = true;
	        }
	        if (!pony.IsPonyOnScreen(current_location, new_location_y, WinMain.screens_to_use) || pony.IsPonyInAvoidanceArea(new_location_y, current_screen)) {
	        	y_bad = true;
	        }
        }
        
        if (!x_bad && !y_bad) {
        	up = !up;
        	right = !right;
        	return;
        }
        
        if (x_bad && y_bad) {
        	up = !up;
        	right = !right;
        	return;
        }
        
        if (x_bad) {
        	right = !right;
        	return;
        }
        
        if (y_bad) {
        	up = !up;
        	return;
        }
    }
    
    // Get the destination location for whatever we are following
    public Point Get_Destination(GraphicsDevice current_screen, Pony pony) {
    	// If we aren't following anything yet
    	if ((follow_object_name.length() > 0 && follow_object == null) || (follow_object != null && !follow_object.isVisible())) {
    		if (pony.Is_Interacting && follow_object_name.trim().equalsIgnoreCase(pony.Current_Interaction.Trigger.Name.trim())) {
    			follow_object = pony.Current_Interaction.Trigger.Form;
    			return new Point(follow_object.getLocation().x + destination_xcoord, follow_object.getLocation().y + destination_ycoord);
    		}
    		if (pony.Is_Interacting && pony.Current_Interaction.Initiator != null && follow_object_name.trim().equalsIgnoreCase(pony.Current_Interaction.Initiator.Name.trim())) {
    			follow_object = pony.Current_Interaction.Initiator.Form;
    			return new Point(follow_object.getLocation().x + destination_xcoord, follow_object.getLocation().y + destination_ycoord);
    		}
    		
    		List<Pony_Form> ponies_to_follow = new LinkedList<Pony_Form>();
    		// Look for a Pony to follow
            for (Pony ipony : WinMain.currentInstance.Active_Ponies) {
                if (ipony.Name.trim().equalsIgnoreCase(follow_object_name.trim()))
                    ponies_to_follow.add(ipony.Form);
            }

            // If one or more ponies found
            if (ponies_to_follow.size() > 0) {
            	// Select one at random to follow
                int dice = WinMain.rand.nextInt(ponies_to_follow.size());
                follow_object = ponies_to_follow.get(dice);
                return new Point(follow_object.getLocation().x + destination_xcoord, follow_object.getLocation().y + destination_ycoord);
            }

            List<Effect_Form> effects_to_follow = new LinkedList<Effect_Form>();
            // Look for an object (effect) to follow
            for(Effect_Form effect : WinMain.currentInstance.Active_Effects) {
                if (effect.effect_name.trim().equalsIgnoreCase(follow_object_name.trim())) {
                    effects_to_follow.add(effect);
                }
            }

            // If one or more objects found
            if (effects_to_follow.size() > 0) {
            	// Select one at random to follow
                int dice = WinMain.rand.nextInt(effects_to_follow.size());
                follow_object = effects_to_follow.get(dice);
                return new Point(follow_object.getLocation().x + destination_xcoord, follow_object.getLocation().y + destination_ycoord);
            }
            
            // Return blank point if nothing found
        	return new Point();
    	}
    	
    	// If we are following an object
	    if (follow_object != null)
	        return new Point(follow_object.getLocation().x + destination_xcoord, follow_object.getLocation().y + destination_ycoord); // Return its current screen position

	    // If we have a coordinate to go to
	    if (destination_xcoord != 0 && destination_ycoord != 0) {
	    	// Return its position on the screen
	    	Rectangle screenBounds = current_screen.getDefaultConfiguration().getBounds();
	        return new Point((int)(((destination_xcoord * screenBounds.getWidth()) / 100) + screenBounds.getMinX()),
	                         (int)(((destination_ycoord * screenBounds.getHeight()) / 100) + screenBounds.getMinY()));
	    }

	    // Otherwise return a blank Point
    	return new Point();
    }
    
    // Add an effect to this behavior
    public void AddEffect(String effectname, ImageIcon right_image, ImageIcon left_image, double duration, double repeat_delay, WinMain.Directions direction_right, WinMain.Directions centering_right, WinMain.Directions direction_left, WinMain.Directions centering_left, boolean follow) {
    	effect new_effect = new effect();
    	
    	new_effect.behavior_name = this.Name;
    	new_effect.Pony_Name = this.Pony_Name;
        new_effect.name = effectname;
        new_effect.right_image = right_image;
        new_effect.left_image = left_image;
        new_effect.duration = duration;
        new_effect.repeat_delay = repeat_delay;
        new_effect.placement_direction_right = direction_right;
        new_effect.centering_right = centering_right;
        new_effect.placement_direction_left = direction_left;
        new_effect.centering_left = centering_left;
        new_effect.follow = follow;

        Effects.add(new_effect);
    }
}
